<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('cities')) {
            Schema::create('cities', function (Blueprint $table) {
                $table->id();
                $table->foreignId('country_id')->default(1)->constrained('countries')->cascadeOnDelete()->cascadeOnUpdate();
                $table->foreignId('governerate_id')->constrained('governorates')->cascadeOnDelete()->cascadeOnUpdate();
                $table->enum('status', ['active', 'inactive'])->default('active');
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (!Schema::hasTable('city_translations')) {
            Schema::create('city_translations', function (Blueprint $table) {
                $table->id();
                $table->foreignId('city_id')->constrained('cities')->cascadeOnDelete()->cascadeOnUpdate();
                $table->string('name');
                $table->string('locale')->index();
                $table->unique(['city_id', 'locale']);
                $table->timestamps();

            });
        }
    }


    public function down(): void
    {
        Schema::dropIfExists('cities');
        Schema::dropIfExists('city_translations');
    }
};
