<?php


namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Collection;

class Governerate extends Model
{
    use Translatable;

	protected $table = 'governorates';

	protected $casts = [
		'status' => 'bool',
		'country_id' => 'int'
	];

	protected $fillable = [
		'status',
		'country_id'
	];
    public $translatedAttributes = [
		'name',
	];

	public function country()
	{
		return $this->belongsTo(Country::class);
	}

	public function cities()
	{
		return $this->hasMany(City::class);
	}

	public function governerate_translations()
	{
		return $this->hasMany(GovernerateTranslation::class , 'governerate_id');
	}
}
