<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckIfVerified
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();

        if ($user && !$user->is_verified) {
            // If the user is not verified, redirect them or return an error response
            return response()->json(['error' => 'Your account is not verified.'], 403);
        }

        return $next($request);
    }
}
