<?php

use Carbon\Carbon;
use App\Models\RFQ;
use App\Models\RfqBid;
use App\Models\Country;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Models\CountryTranslation;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Contracts\Role;
use App\Http\Resources\CountryResource;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\SettingController;
use App\Http\Controllers\Api\Admin\PageController;
use App\Http\Controllers\Api\Dentist\CartController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\vendor\BranchController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::middleware(['locale'])->group(function () {

    Route::middleware(['auth:sanctum'])->group(function () {

        Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');

        // Send a new notification
        Route::post('/notifications/send', [NotificationController::class, 'send'])->name('notifications.send');

        // Mark a specific notification as read
        Route::post('/notifications/{id}/read', [NotificationController::class, 'markAsRead'])->name('notifications.markAsRead');

        // Mark all notifications as read
        Route::post('/notifications/read-all', [NotificationController::class, 'markAllAsRead'])->name('notifications.markAllAsRead');

        // Delete a specific notification
        Route::delete('/notifications/{id}', [NotificationController::class, 'delete'])->name('notifications.delete');

        // Delete all notifications
        Route::delete('/notifications', [NotificationController::class, 'deleteAll'])->name('notifications.deleteAll');

        Route::controller(ProfileController::class)->group(function () {
            Route::get('profile', 'MyProfile');
            Route::post('update-profile', 'update');
            Route::post('update-password', 'updateProfilePassword');
            Route::post('bank-info', 'BankAccount');
            Route::post('/cart/add', [CartController::class, 'addToCart']);
            Route::post('delete-account', [ProfileController::class, 'deleteAccount']);

        });
    });
    Route::controller(AuthController::class)->group(function () {
        Route::post('register', 'Register');
        Route::post('login', 'login');
        Route::post('verify-email', 'verify');
        Route::post('send-code', 'sendPasswordResetEmail');
        Route::post('check-code', 'checkResetCode');
        Route::post('reset-password', 'resetPassword');
    });

    Route::controller(SettingController::class)->group(function () {
        Route::get('countries', 'countries');
        Route::get('cities', 'cities');
        Route::get('govers', 'govers');
        Route::get('currencies', 'currencies');
        Route::get('setting', 'setting');
        Route::get('bank-data', 'getBankData');

        Route::resource('pages', PageController::class)->only(['index', 'show']);
    });

    route::get('test', function () {
        $rfq_deadline = Setting::select('rfq_time')->first();
        $current_time = now()->format('H:i');
        // dd();
        $bids = RfqBid::where('is_approved', 1)->get();
        // dd(Carbon::parse($rfq_deadline->rfq_time)->format('H:i') == $current_time);
        if (Carbon::parse($rfq_deadline->rfq_time)->format('H:i') == $current_time) {
            foreach ($bids as $bid) {
                $rfq = RFQ::find($bid->rfq_id);
                $rfq->vendor_id = $bid->vendor_id;
                $rfq->save();
            }
            return "تم التصديق بالمزايدات";
        }
        return "لسه";
    });
});
