<?php

namespace App\Http\Resources\Api\Admin;

use App\Http\Resources\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'name'=>$this->name,
            'image'=>MediaResource::make($this->image),
            'parent_id' =>$this->parent_id,
            'sub_categories' => SubCategoryResource::collection($this->whenLoaded('children'))
        ];
    }
}
