<?php

namespace App\Http\Controllers\Api\Dentist;

use App\Models\Card;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Api\Dentist\CardRequest;
use App\Http\Resources\Api\Dentist\CardResource;

class CardController extends Controller
{
    use HasCrudActions;

    protected $model = Card::class;

    protected $resource = CardResource::class;

    protected $request = CardRequest::class;


    public function index()
    {
        $model = app($this->model);

        // Use the method to retrieve relations for eager loading

        $relations = method_exists($model, 'getWithRelations') ? $model->getWithRelations() : [];

        $modelResource = $this->search()->where('user_id' , Auth::id())->with($relations);
        return $this->apiResponse('200', __('success'), '', $modelResource->orderBy('id', 'DESC')->get());
    }
}
