<?php

namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;

class SettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'registeration_vendors' => 'required|boolean',
            'registeration_clinics' => 'required|boolean',
            'product_access' => 'required|boolean',
            'direct_orders' => 'required|boolean',
            'payment_methods' => 'required|boolean',
            'currency_id' => 'nullable|exists:currencies,id',
        'rfq_time' => 'nullable',
        ];
    }
}
