<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Create a dentist user
        User::create([
            'owner_name' => 'Dr. John Doe',
            'email' => 'dentist@example.com',
            'country_code' => '+1',
            'verification_code' => Str::random(10),
            'email_verified_at' => now(),
            'type' => 'dentist',
            'country_id' => 1,
            'password' => Hash::make('password123'),
            'mobile' => '1234567890',
            'remember_token' => Str::random(10),
        ]);

        // Create a vendor user
        User::create([
            'owner_name' => 'Vendor Corp',
            'email' => 'vendor@example.com',
            'country_code' => '+44',
            'verification_code' => Str::random(10),
            'email_verified_at' => now(),
            'type' => 'vendor',
            'country_id' => 1,

            'password' => Hash::make('password123'),
            'mobile' => '0987654321',
            'remember_token' => Str::random(10),
        ]);

        // Create an employee user
        User::create([
            'owner_name' => 'Jane Smith',
            'email' => 'employee@example.com',
            'country_code' => '+91',
            'verification_code' => Str::random(10),
            'email_verified_at' => now(),
            'role_name' => 'Employee',
            'branch_id' => 3,
            'country_id' => 1,

            'type' => 'employee',
            'password' => Hash::make('password123'),
            'mobile' => '1122334455',
            'remember_token' => Str::random(10),
        ]);


    }
}
