<?php

namespace App\Traits;

trait SearchableRelations
{
    /**
     * Scope to search related models based on searchable fields.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param array $searchableFields
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeSearchRelated($query, array $searchableFields)
{
    foreach ($searchableFields as $relationName => $fields) {
        if (method_exists($this, $relationName)) {
            $query->where(function ($query) use ($relationName, $fields) {
                $query->whereHas($relationName, function ($relationQuery) use ($fields) {
                    foreach ($fields as $field => $value) {
                        $relationQuery->where($field, 'LIKE', "%$value%");
                    }
                })->orWhereDoesntHave($relationName);
            });
        } else {
            $query->where(function ($query) use ($fields) {
                foreach ($fields as $field => $value) {
                    $query->orWhere($field, 'LIKE', "%$value%");
                }
            });
        }
    }

    return $query;
}



    public function scopeSearchRelatedTranslation($query, array $translationFields){
        foreach ($translationFields as $relationName => $fields) {
            if (method_exists($this, $relationName)) {
                $query->whereHas($relationName, function ($qe) use ($fields) {
                    foreach ($fields as $field => $value) {
                            $qe->whereHas('translations', function ($qt) use ($field,$value) {
                                $qt->where($field, 'like', '%' . $value . '%');
                            });
                    }
                });
            }
        }
        return $query;

    }

    public function scopeSearchwithTranslation($query, array $translationFields){
        foreach ($translationFields as $field => $value) {
            $query->whereHas('translations', function ($qt) use ($field,$value) {
                $qt->where($field, 'like', '%' . $value . '%');
            });
        }
        return $query;
    }

    /**
     * Scope to search across the entire dataset.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param array $searchableFields
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeSearchAll($query, array $searchableFields)
    {
        foreach ($searchableFields as $field => $value) {
            $query->where($field, 'LIKE', "%$value%");
        }

        return $query;
    }
}
