<?php

namespace App\Http\Middleware;

use App\Traits\ApiResponse;
use App\Traits\HasCrudActions;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckProductsAccess
{
    use ApiResponse;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if(auth()->user()->products_access == false){
            return $this->apiResponse(Response::HTTP_FORBIDDEN, 'fail', __('Unauthorized'));

        }
        return $next($request);
    }
}
