<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\Category;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Admin\SubCategoryRequest;
use App\Http\Resources\Api\Admin\SubCategoryResource;

class SubCategoryController extends Controller
{
    use HasCrudActions;

    protected $model = Category::class;

    protected $resource = SubCategoryResource::class;

    protected $request = SubCategoryRequest::class;

    public function index()
    {
        $modelResource = $this->search()->with('children');

        return $this->ApiResponse('200', __('success'), '', SubCategoryResource::collection($modelResource->whereNotNull('parent_id')->orderBy('id' , 'DESC')->with('children')->get()));

    }

    public function show($id , $main_category_id){
        $record = $this->model::where(['parent_id' => $id,'main_category_id' => $main_category_id])->get();



        return $this->ApiResponse('200', __('success'), '',  SubCategoryResource::collection($record));
    }
}
